/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.render.TileEntityTurtleRenderer;
import dan200.computercraft.client.render.TransformedBakedModel;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.shared.turtle.items.ItemTurtle;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.BakedModelWrapper;

public class TurtleSmartItemModel
extends BakedModelWrapper<BakedModel> {
    private static final Transformation identity;
    private static final Transformation flip;
    private final BakedModel familyModel;
    private final BakedModel colourModel;
    private final Map<TurtleModelCombination, List<BakedModel>> cachedModels = new HashMap<TurtleModelCombination, List<BakedModel>>();

    public TurtleSmartItemModel(BakedModel familyModel, BakedModel colourModel) {
        super(familyModel);
        this.familyModel = familyModel;
        this.colourModel = colourModel;
    }

    @Nonnull
    public BakedModel applyTransform(@Nonnull ItemTransforms.TransformType cameraTransformType, @Nonnull PoseStack poseStack, boolean applyLeftHandTransform) {
        this.originalModel.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
        return this;
    }

    @Nonnull
    public List<BakedModel> getRenderPasses(ItemStack stack, boolean fabulous) {
        if (!(stack.m_41720_() instanceof ItemTurtle)) {
            return this.familyModel.getRenderPasses(stack, fabulous);
        }
        ItemTurtle turtle = (ItemTurtle)stack.m_41720_();
        int colour = turtle.getColour(stack);
        ITurtleUpgrade leftUpgrade = turtle.getUpgrade(stack, TurtleSide.LEFT);
        ITurtleUpgrade rightUpgrade = turtle.getUpgrade(stack, TurtleSide.RIGHT);
        ResourceLocation overlay = turtle.getOverlay(stack);
        boolean christmas = HolidayUtil.getCurrentHoliday() == Holiday.CHRISTMAS;
        String label = turtle.getLabel(stack);
        boolean flip = label != null && (label.equals("Dinnerbone") || label.equals("Grumm"));
        TurtleModelCombination combo = new TurtleModelCombination(colour != -1, leftUpgrade, rightUpgrade, overlay, christmas, flip);
        return this.cachedModels.computeIfAbsent(combo, this::buildModel);
    }

    private List<BakedModel> buildModel(TurtleModelCombination combo) {
        Minecraft mc = Minecraft.m_91087_();
        ModelManager modelManager = mc.m_91291_().m_115103_().m_109393_();
        Transformation transformation = combo.flip ? flip : identity;
        ArrayList<BakedModel> parts = new ArrayList<BakedModel>(4);
        parts.add((BakedModel)new TransformedBakedModel(combo.colour() ? this.colourModel : this.familyModel, transformation));
        ResourceLocation overlayModelLocation = TileEntityTurtleRenderer.getTurtleOverlayModel(combo.overlay(), combo.christmas());
        if (overlayModelLocation != null) {
            parts.add((BakedModel)new TransformedBakedModel(modelManager.getModel(overlayModelLocation), transformation));
        }
        if (combo.leftUpgrade() != null) {
            parts.add((BakedModel)new TransformedBakedModel(TurtleUpgradeModellers.getModel(combo.leftUpgrade(), null, TurtleSide.LEFT)).composeWith(transformation));
        }
        if (combo.rightUpgrade() != null) {
            parts.add((BakedModel)new TransformedBakedModel(TurtleUpgradeModellers.getModel(combo.rightUpgrade(), null, TurtleSide.RIGHT)).composeWith(transformation));
        }
        return parts;
    }

    static {
        PoseStack stack = new PoseStack();
        stack.m_85841_(0.0f, -1.0f, 0.0f);
        stack.m_85837_(0.0, 0.0, 1.0);
        identity = Transformation.m_121093_();
        flip = new Transformation(stack.m_85850_().m_85861_());
    }

    private record TurtleModelCombination(boolean colour, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, ResourceLocation overlay, boolean christmas, boolean flip) {
    }
}

